@extends('layouts.admin')

@section('title', 'View Transaction')

@section('content')
<div class="dashboard-container">
    <div class="users-header">
        <h2>Transaction Details</h2>
        <div class="users-actions">
            <a href="{{ route('admin.transactions.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Transactions
            </a>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <div class="dashboard-card mt-4">
                <div class="dashboard-card-header">
                    <h3>Transaction Information</h3>
                </div>
                <div class="dashboard-card-body">
                    <table class="table table-details">
                        <tr>
                            <th>Transaction ID:</th>
                            <td>{{ $transaction->id }}</td>
                        </tr>
                        <tr>
                            <th>Payment ID:</th>
                            <td>{{ $transaction->transaction_id ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Status:</th>
                            <td>
                                <span class="status-badge status-{{ $transaction->status }}">
                                    {{ ucfirst($transaction->status) }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Amount:</th>
                            <td>{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->amount, 2) }}</td>
                        </tr>
                        <tr>
                            <th>IP Address:</th>
                            <td>{{ $transaction->ip_address }}</td>
                        </tr>
                        <tr>
                            <th>Created At:</th>
                            <td>{{ $transaction->created_at->format('M d, Y H:i:s') }}</td>
                        </tr>
                        <tr>
                            <th>Updated At:</th>
                            <td>{{ $transaction->updated_at->format('M d, Y H:i:s') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="dashboard-card mt-4">
                <div class="dashboard-card-header">
                    <h3>User & Package Details</h3>
                </div>
                <div class="dashboard-card-body">
                    <h4>User</h4>
                    <table class="table table-details">
                        <tr>
                            <th>Name:</th>
                            <td>
                                <a href="{{ route('admin.users.show', $transaction->user) }}">
                                    {{ $transaction->user->name }}
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>Steam ID:</th>
                            <td>{{ $transaction->user->steamid }}</td>
                        </tr>
                    </table>
                    
                    <h4 class="mt-4">Package</h4>
                    <table class="table table-details">
                        <tr>
                            <th>Package:</th>
                            <td>
                                <a href="{{ route('admin.packages.show', $transaction->package) }}">
                                    {{ $transaction->package->name }}
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>Price:</th>
                            <td>{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->package->price, 2) }}</td>
                        </tr>
                        <tr>
                            <th>Type:</th>
                            <td>{{ ucfirst($transaction->package->type) }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    @if($transaction->paypal_data)
    <div class="dashboard-card mt-4">
        <div class="dashboard-card-header">
            <h3>Payment Gateway Data</h3>
        </div>
        <div class="dashboard-card-body">
            <pre>{{ json_encode(is_string($transaction->paypal_data) ? json_decode($transaction->paypal_data) : $transaction->paypal_data, JSON_PRETTY_PRINT) }}</pre>
        </div>
    </div>
    @endif
</div>
@endsection
